;DRVNO:	ASK AdamNet Node (4 or 6):
;ETSKEW:	ASK E&T (=1) or Orphanware Skew (=0):

DRVNO	EQU	4
ETSKEW	EQU	1
;
P1DDR	EQU	00H	;port 1 data direction register
P2DDR	EQU	01H	;port 2 data direction register
P1DATA	EQU	02H	;port 1 data register
P2DATA	EQU	03H	;port 2 data register
P4DDR	EQU	05H	;port 4 data direction register
TCSR	EQU	08H	;timer control and status register
COUNTER	EQU	09H	;counter register
OUTCMP	EQU	0BH	;output compare register
RMCR	EQU	10H	;SCI rate and mode control register
SCICSR	EQU	11H	;SCI Tx/Rx control and status register
SCIRXD	EQU	12H	;SCI Rx data register
SCITXD	EQU	13H	;SCI Tx data register
RAMCR	EQU	14H	;RAM control register
CURMSG	EQU	80H	;command message buffer (instructions for send/rcv)
LSTMSG	EQU	85H	;last command buffer
STRLEN	EQU	8AH	;message length
BLKLOC	EQU	8CH	;where in memory to get/save message
CHKSUM	EQU	8EH	;calculated checksum
MSTAT	EQU	8FH	;status message buffer
CSTAT	EQU	93H	;combined status
PSTAT	EQU	94H	;primary status
SSTAT	EQU	95H	;secondary status
L0096	EQU	96H
DEVNUM	EQU	98H	;device node ID
CMDSTG	EQU	99H	;command stage for multi-byte commands
DATREQ	EQU	9EH	;data requested flag
RDWRT	EQU	9FH	;read(=0BH)/write(=0CH) flag
INTHAN	EQU	0A0H	;address for interrupt handler
DMADDR	EQU	0A2H	;address for DMA with FDC
STFDC	EQU	0A4H	;FDC status
REQTRK	EQU	0A5H	;requested track
REQSEC	EQU	0A6H	;requested sector
CURSEC	EQU	0A7H	;current sector
CURTRK	EQU	0A8H	;current track
SECRTY	EQU	0A9H	;sector retries
RETRY	EQU	0AAH	;block retries
DRVUSE	EQU	0ABH	;has the drive been used?
MOTON	EQU	0ACH	;is the motor on
FMTTRK	EQU	0E9H	;track being formatted
FMTSEC	EQU	0EAH	;sector being formatted
FMTRTRY	EQU	0EBH	;retries while formatting
SIDE	EQU	0ECH	;side being formatted
;
SECHGH	EQU	18	;sectors per track in high density mode
SECLOW	EQU	SECHGH/2	;sectors per track in low density mode
MAXTRK	EQU	80
;
BLKWRT	EQU	400H		;write to external memory
FDCSTAT	EQU	800H		;FDC status register
BLKRD	EQU	1400H		;read from external memory
FDCCMD	EQU	1800H		;FDC command register
FDCTRK	EQU	3800H		;FDC track register
FDCSEC	EQU	5800H		;FDC sector register
RDMA0	EQU	6C00H		;DMA read from FDC to 0 to 1FFH of ext. mem.
RDMA1	EQU	6E00H		;DMA read from FDC to 200H to 3FFH of ext. mem.
FDCDAT	EQU	7800H		;FDC data register
WDMA0	EQU	7C00H		;DMA write to FDC from 0 to 1FFH of ext. mem.
WDMA1	EQU	7E00H		;DMA write to FDC from 200H to 3FFH of ext. mem.
;
;AdamNet Messages where N = Node ID
; 0N	-	reset node
; 1N	-	request status
; 3N	-	clear
; 4N	-	receive
; 6N	-	send
;0DN	-	ready
;
;	The disk drive code comprises two separate devices, the net handler
;	and the disk handler.  The net handler is only triggered when the 6803
;	receives a byte over AdamNet.  It interprets the AdamNet command, acts
;	on the command (including sending and receiving blocks of data over the
;	Net) and sets the appropriate flags and data blocks in memory.  The 
;	disk handler is normally in control of the drive.  It initializes the
;	various flags and hardware and then loops, monitoring the data request 
;	flag.  When it finds a data request, it reads or writes to the disk 
;	drive, depending upon the read/write flag.  If the disk handler gets
;	a request to write to block FACEH, it does a format.
;
;AdamNet procedure to write to disk:
;  1)	Master node uses send command to send block specifications to disk drive. 
;	Block spec. is 5 bytes, 4 bytes block number (LSB ... MSB) and one byte
;	device spec (0 = primary device, NZ = secondary device). The net
;       handler puts all blocks less than 400H in message buffer.  Blocks of
;	400H go in external memory.
;  2)   Master node uses send command to send data block to disk.
;  3)	Net handler sets data request and write flags and returns to disk
;	handler.
;  4)	Disk handler sees flags, reads the block specification and writes
;	external memory to disk.
;AdamNet procedure to read from disk:
;  1)	Master node uses send command to send block specifications to disk drive. 
;  2)   Master node uses receive command to tell disk drive to send data block.
;  3)	Net handler sets data request and read flags and returns to disk
;	handler.
;  4)	Disk handler sees flags, reads the block specification and reads data
;	from disk to external memory.
;  5)	Meanwhile master node queries drive with RDY command.
;  6)	Drive ACKs ready when disk handler has comleted task.
;  7)	Master node then uses CLEAR command to tell net handler to send data.
;  8)	Net handler now sends data in external memory
;
;
	ORG	0F000H
RESET:
	SEI			;disable interrupts
	LDS	#$0E8		;set stack pointer to E8
	LDAA	#$7A		;set port 1 data direction to 01111010
	STAA	P1DDR
	LDAA	#$0FF		;set port 4 data direction to 11111111
	STAA	P4DDR
	LDAA	#$15		;set port 2 data direction to 00010101
	STAA	P2DDR
	LDAA	#$0C		;set SCI rate & mode 62.5 kbaud, external clock
	STAA	RMCR
	LDAA	#$1B		;enable Rx, Tx, Wakeup
	STAA	SCICSR
	LDAA	#$0FF		;enable internal ram
	STAA	RAMCR
	LDAA	#$10		;disable precomp;set double density, side 0,
				;drive 1, motor off 00010000
	STAA	P1DATA
	LDX	#$0FF		;start clearing memory at 0FFH
RESET1:
	CLR	$0,X		;reset memory
	DEX			;decrement pointer
	CPX	#$80		;is it 80H
	BCC	RESET1		;no, loop
	DEC	LSTMSG+4	;set lstmsg+4 to 0FFH
	INC	DRVUSE		;set DRVUSE to 1
	LDAA	P1DATA		;read port 1
	ANDA	#$80		;is switch on back set to drive ID 2
	CLC			;clear carry
	ROLA			;move bit 7 to bit 1
	ROLA
;
	ORAA	#DRVNO		;or in base drive ID 
;
	STAA	DEVNUM		;save it
	JSR	HGHDEN
	LDX	#MAIN		;MAIN is to be executed by interrupt
	STX	INTHAN		;save it
	JMP	DSKRES
MAIN:
	LDX	#FDCSTAT	;read FDC status register
	LDAB	$0,X
	LDX	#MAIN		;set up interrupt handler
	STX	INTHAN
	LDAA	MOTON		;is MOTON 0 yet?
	BEQ	MAIN1		;branch if so
	LDAA	#$40		;is the output compare flag set
	BITA	TCSR
	BEQ	MAIN1		;branch if not
	LDAA	TCSR		;read TCSR
	LDD	COUNTER		;set output compare to counter+3E80H
	ADDD	#$3E80
	STD	OUTCMP
	DEC	MOTON		;decrement MOTON
	BNE	MAIN1		;non-zero, skip next
	LDAA	P1DATA
	ANDA	#$9F		;turn motor off, select drive 1 10011111
	STAA	P1DATA
MAIN1:
	LDAA	DATREQ		;is there a data request
	BNE	MAIN5		;yes, skip next
;	LDAB	#$4		;set secondary status to missing drive
;	LDAB	#$0E		;Use OE for Orphanware Skew
	LDAB	#$0D		;Use OD for E&T Skew
	LDAA	P1DATA
	ANDA	#$8
	BEQ	MAIN2
	LDAB	#$0F
MAIN2:
	STAB	SSTAT
	LDAB	P1DATA		;test if disk in place
	BITB	#$1
	BEQ	MAIN3		;jump if it is
	LDAA	#$3		;set primary status to missing media
	STAA	PSTAT
	LDAA	#$0FF		;invalidate last command
	STAA	LSTMSG+4
	LDAA	#$1
	STAA	DRVUSE
	LDAA	P1DATA		;motor off, select drive 1
	ANDA	#$9F		;10011111
	STAA	P1DATA
	BRA	MAIN4
MAIN3:
	CLRA			;put 0 in A
	LDAB	PSTAT		;primary status in B
	CMPB	#$3		;missing media or less
	BCS	MAIN4		;yes, skip next
	CMPB	#$5		;write protected
	BEQ	MAIN4		;yes,skip next
	PSHA			;save A and B
	PSHB
	LDAA	P1DATA
	ORAA	#$50		;select side 0, turn motor on 1010000
	STAA	P1DATA
	JSR	RCOUNT		;restore counter
	PULB			;restore A & B
	PULA
	CMPB	#$5		;write protected?
	BEQ	MAIN4		;yes, skip next
	STAA	PSTAT		;save new primary status
MAIN4:
	LDAA	DATREQ		;is there a data request
	BEQ	MAIN		;no, return to start of main loop
MAIN5:
	CMPA	#$0FF		;is it reset drive request
	BNE	MAIN6
	JMP	RESDRV		;yes, skip next
MAIN6:
	LDAB	CURMSG+4	;is the primary device requested?
	BEQ	DODATA		;yes, skip next
	CLR	DATREQ		;clear data request
	JMP	MAIN		;loop some more
DODATA:
	SEI			;disable interrupts
	LDAA	P1DATA		;test if disk in place
	BITA	#$1
	BEQ	DODAT1		;yes, skip next
	JMP	DSKRES		;reset disk system
DODAT1:
	JSR	SELDRV		;select the drive
	LDX	#$0B4		;wait count
DODAT2:
	DEX
	BNE	DODAT2
	TST	DRVUSE		;is this the first time the drive is used?
	BEQ	DODAT3		;no, skip next
	JSR	HOMDSK		;home the disk
	CLR	DRVUSE		;set used flag
DODAT3:
	LDAA	RDWRT		;test read/write flag
	CMPA	#$0C		;is it write?
	BNE	RDWRIT		;no, skip next
	LDX	CURMSG		;get requested block
	CPX	#$53CA		;is it CA53
	BEQ	NOTFMT		;yes, skip next
CHKFMT:
	CPX	#$0CEFA		;is it format = FACEH
	BNE	CHKFM1		;no, skip next
	JSR	FORMAT		;do the format
	BRA	CHKFM2
CHKFM1:
	CPX	#$0CFFA		;is it low format = FACFH
	BNE	RDWRIT		;no, skip next
	JSR	LFORM		;do the format
CHKFM2:
	CLR	REQTRK		;set requested track to 0
	LDAA	#$0FF		;set all message bytes to 0FFH
	TAB
	STD	LSTMSG
	STD	LSTMSG+2
	STAA	LSTMSG+4
	STD	CURMSG
	STD	CURMSG+2	;should be +2 #######
	STAA	CURMSG+4	; and +4
	LDAA	FMTTRK
	CLR	FMTTRK
	CMPA	#$FF
	BEQ	NOTFMT
	JMP	MISBLK
NOTFMT:
	JMP	OKRDWR		;finish up with no error
;
RDWRIT:
	JSR	CLCTRK		;calculate track and sector
	BCC	RDWRT1		;if good, jump
	JMP	MISBLK		;finish up with error
RDWRT1:
	LDAA	RDWRT		;get read/write flag
	CMPA	#$0B		;is it read
	BEQ	RDBLK		;yes, do read
	CMPA	#$0C		;is it write
	BEQ	RDWRT2		;yes, do write
	JMP	OKRDWR		;else finish up no error
RDWRT2:
	JMP	WRTBLK
RESDRV:
	JSR	SELDRV		;turn drive on and select it
	JSR	HOMDSK		;home the disk
	JMP	RESET		;reset entire drive system
RDBLK:
	LDAA	P1DATA		;is disk in place
	BITA	#$1
	BEQ	RDBLK1		;yes, jump
	JMP	MISMED		;end with error
RDBLK1:
	JSR	SELDRV		;turn on drive
	LDAA	#$4		;set retry count to 5
	STAA	RETRY
RDBLK2:
	LDD	#RDMA0		;DMA read to 1st half of memory
	STD	DMADDR
	LDAA	REQTRK		;seek to track
	JSR	SKTRK
	BNE	RDERR		;if seek error
	LDAA	P1DATA
	ANDA	#$8
	BEQ	RDBLK4
	LDAA	REQSEC		;get logical sector
	JSR	HSECTRN		;translate to physical sector
	JSR	RDHSEC		;read it
	TSTA			;test error code
	BNE	RDERR		;jump if error
	LDD	#RDMA1		;DMA read to 2nd half of memory
	STD	DMADDR
	LDAA	REQSEC		;get logical sector
	INCA			;increase by 1
	CMPA	#SECHGH+1	;past last sector on track
	BCS	RDBLK3		;no, jump
	LDAA	REQTRK		;get requested track
	INCA			;increment to next track
	JSR	SKTRK		;seek to it
	BEQ	RDBL2A
	JMP	MISBLK		;if seek error
RDBL2A:
	LDAA	#$1		;must want first logical sector
RDBLK3:
	JSR	HSECTRN		;translate logical to physical
	JSR	RDHSEC		;read sector
	BRA	RDBLK6
RDBLK4:
	LDAA	REQSEC		;get logical sector
	JSR	LSECTRN		;translate to physical sector
	JSR	RDLSEC		;read it
	TSTA			;test error code
	BNE	RDERR		;jump if error
	LDD	#RDMA1		;DMA read to 2nd half of memory
	STD	DMADDR
	LDAA	REQSEC		;get logical sector
	INCA			;increase by 1
	CMPA	#SECLOW+1	;past last sector on track
	BCS	RDBLK5		;no, jump
	LDAA	REQTRK		;get requested track
	INCA			;increment to next track
	JSR	SKTRK		;seek to it
	BEQ	RDBL4A
	JMP	MISBLK		;if seek error
RDBL4A:
	LDAA	#$1		;must want first logical sector
RDBLK5:
	JSR	LSECTRN		;translate logical to physical
	JSR	RDLSEC		;read sector
RDBLK6:
	TSTA			;test for error
	BEQ	OKRD		;everything is OK
RDERR:
	LDAB	RETRY		;get retries
	DECB			;any left
	STAB	RETRY		;save them
	BNE	RDRETRY		;do retry
	DECA			;look at error
	BEQ	RDMBLK		;if 0, missing block
	DECA
	BEQ	RDMBLK		;still missing block
	DECA
	BEQ	RDCRC		;CRC error
	JMP	MISMED		;only thing left
RDMBLK:
	JMP	MISBLK		;end up with missing block error code
RDCRC:
	JMP	CRC		;end up with crc error code
RDRETRY:
	CMPB	#$2
	BNE	RDRTR1
	JSR	FLPDEN
	JSR	CLCTRK
	BCS	RDMBLK
	LDAA	REQTRK		;seek to track
	JSR	SKTRK
	BNE	RDMBLK		;if seek error
RDRTR1:
	JSR	HOMDSK		;home the disk
	JMP	RDBLK2		;do retry
OKRD:
	LDD	CURMSG		;transfer current message to last message
	STD	LSTMSG
	LDD	CURMSG+2
	STD	LSTMSG+2
	LDAA	CURMSG+4
	STAA	LSTMSG+4
	JMP	OKRDWR		;finish up, no error
WRTBLK:
	LDAA	P1DATA		;is disk present
	BITA	#$1
	BEQ	WRBLK1
	JMP	MISMED		;no, exit with error
WRBLK1:
	LDAA	#$0FF		;force new read
	STAA	LSTMSG+4
	JSR	SELDRV		;select the drive
	LDAA	#$4		;set retries
	STAA	RETRY
WRBLK2:
	LDD	#WDMA0		;DMA write from 1st half of memory
	STD	DMADDR
	LDAA	REQTRK
	JSR	SKTRK		;seek to requested track
	BNE	WRTERR		;jump if error
	LDAA	P1DATA
	ANDA	#$8
	BEQ	WRBLK4
	LDAA	REQSEC		;get logical sector
	JSR	HSECTRN		;translate to physical sector
	JSR	WRHSEC		;read it
	TSTA
	BNE	WRTERR
	LDD	#WDMA1		;DMA write from 2nd half of memory
	STD	DMADDR
	LDAA	REQSEC		;get requested sector
	INCA			;go for next
	CMPA	#SECHGH+1	;past end of track?
	BCS	WRBLK3		;jump if not
	LDAA	REQTRK		;seek to next track
	INCA
	JSR	SKTRK
	BNE	MISBLK		;if seek error
	LDAA	#$1		;get first sector
WRBLK3:
	JSR	HSECTRN		;logical to physical translation
	JSR	WRHSEC		;write sector
	BRA	WRBLK6
WRBLK4:
	LDAA	REQSEC		;get logical sector
	JSR	LSECTRN		;translate to physical sector
	JSR	WRLSEC		;read it
	TSTA
	BNE	WRTERR
	LDD	#WDMA1		;DMA write from 2nd half of memory
	STD	DMADDR
	LDAA	REQSEC		;get requested sector
	INCA			;go for next
	CMPA	#SECLOW+1		;past end of track?
	BCS	WRBLK5		;jump if not
	LDAA	REQTRK		;seek to next track
	INCA
	JSR	SKTRK
	BNE	MISBLK		;if seek error
	LDAA	#$1		;get first sector
WRBLK5:
	JSR	LSECTRN		;logical to physical translation
	JSR	WRLSEC		;write sector
WRBLK6:
	TSTA
	BEQ	OKRDWR
WRTERR:
	LDAB	RETRY		;get retry count
	DECB			;any left?
	STAB	RETRY		;save retries
	BNE	WRRETRY		;do retry
	CMPA	#$4		;look at error code
	BEQ	MISMED		;must be missing media
	CMPA	#$3
	BNE	MISBLK		;must be missing block
	LDAA	#$5		;must be write-protected
	BRA	DSKDN
WRRETRY:
	CMPB	#$2
	BNE	WRRTR1
	JSR	FLPDEN
	JSR	CLCTRK
	BCS	MISBLK
	LDAA	REQTRK		;seek to track
	JSR	SKTRK
	BNE	MISBLK		;if seek error
WRRTR1:
	JSR	HOMDSK		;home disk
	JMP	WRBLK2		;go back for retry
OKRDWR:
	CLRA			;no error so clear A
	BRA	DSKDN
MISMED:
	LDD	CURMSG		;transfer current message to last message
	STD	LSTMSG
	LDD	CURMSG+2
	STD	LSTMSG+2
	LDAA	CURMSG+4
	STAA	LSTMSG+4
	LDAA	#$3		;status = missing media
	BRA	DSKDN
CRC:
	LDAA	#$1		;status = CRC error
	BRA	DSKDN
MISBLK:
	LDAA	#$2		;status = missing block error
DSKDN:
	STAA	PSTAT
;	BRA	DSKDN1
;
;	STAA	SSTAT		;unused code for secondary device
DSKDN1:
	CLR	DATREQ
	LDAA	#$1B		;enable Tx, Rx, Wakeup
	STAA	SCICSR
DSKRES:
	JSR	RCOUNT
	LDAA	#$1B		;enable Tx, Rx, Wakeup
	STAA	SCICSR
	CLRA
	STAA	CMDSTG		;reset command stage
	CLI			;enable interrupts
	JMP	MAIN		;wait loop
;
CLCTRK:
	PSHB			;save accumulators
	PSHA
	CLR	REQTRK		;initialize REQTRK to -1
	DEC	REQTRK
	LDAA	P1DATA
	ORAA	#$70		;select drive, motor on, side 0 01110000
	STAA	P1DATA
	ANDA	#$8
	BEQ	CLCTR2
	LDAB	CURMSG		;get requested block in A & B
	LDAA	CURMSG+1
	LSLD			;multiply by 2 to go from 1K to 512 byte blocks
CLCTR1:
	SUBD	#SECHGH		;divide sector requested by 8
	INC	REQTRK		;keeping count in REQTRK
	BCC	CLCTR1		;until overflow
	ADDD	#SECHGH+1	;add back overflow + 1 (sectors start at 1 not 0)
	BRA	CLCTR4
CLCTR2:
	LDAB	CURMSG		;get requested block in A & B
	LDAA	CURMSG+1
	LSLD			;multiply by 2 to go from 1K to 512 byte blocks
CLCTR3:
	SUBD	#SECLOW		;divide sector requested by 8
	INC	REQTRK		;keeping count in REQTRK
	BCC	CLCTR3		;until overflow
	ADDD	#SECLOW+1		;add back overflow + 1 (sectors start at 1 not 0)
CLCTR4:
	LDAA	REQTRK		;check if requested track > MAXTRK
	CMPA	#MAXTRK*2
	BCC	CLCTR5		;yes, skip next
	STAB	REQSEC		;save calculated sector
	SEC			;set carry
CLCTR5:
	TPA			;transfer condition code register to A
	EORA	#$1		;reverse what was the carry
	TAP			;transfer A to condition code register
	PULA			;restore A & B
	PULB
	RTS
HOMDSK:
	LDAA	P1DATA		;check if disk in place
	BITA	#$1
	BNE	HOMDK2		;if not finish up
	LDX	#HOMDK2		;set up interrupt handler
	STX	INTHAN
	LDX	#FDCCMD		;prepare to write to FDC command register
	LDAA	#$5		;restore command with verify and 6ms step rate
	STAA	$0,X		;do it
	LDAA	#$1
HOMDK1:
	BITA	P1DATA		;keep testing for disk in place
	BEQ	HOMDK1
	JSR	FORINT		;oops, disk gone so force interrupt
HOMDK2:
	LDX	#FDCTRK		;prepare to write to FDC track register
	CLRA
	STAA	$0,X		;put a 0 there
	STAA	CURTRK		;and in current track
	RTS
SKTRK:
	LDAB	P1DATA		;is disk in plce
	BITB	#$1
	BNE	DSKERR		;no, branch to error
	CMPA	#MAXTRK*2	;is track greater than 80
	BCC	DSKERR		;yes, branch to error
	LSRA			;divide by 2
	BCC	SKTRK1		;if odd, skip next
;comment out next 3 lines if using 2797 side select line
	LDAB	P1DATA		;select side 1
	ANDB	#$0EF		;11101111
	STAB	P1DATA
;	LDAB	#$2		;for read/write sector *******
;	STAB	SIDE		;********
	BRA	SKTRK2		;skip next
SKTRK1:
;comment out next 3 lines if using 2797 side select line
	LDAB	P1DATA		;select side 0
	ORAB	#$10		;00010000
	STAB	P1DATA
;	CLR	SIDE		;*******
SKTRK2:
	LDX	#SKTRK4		;set up interrupt handler
	STX	INTHAN
	LDX	#FDCDAT		;prepare to write to FDC data register
	STAA	$0,X		;put track there
	STAA	CURTRK		;save in current track
	LDX	#FDCCMD		;prepare to write to FDC command register
	LDAB	#$15		;seek commmand, with verify and 6ms step rate
	STAB	$0,X		;do it
	LDAA	#$1
SKTRK3:
	BITA	P1DATA		;keep testing disk in place
	BEQ	SKTRK3		;until FDC interrupts out
	JSR	FORINT		;oops, disk out so force interrupt
	BRA	DSKERR		;and send error
SKTRK4:
	LDAA	CURTRK		;get current track
	LDX	#FDCTRK		;get ready to write to FDC track register
	STAA	$0,X		;put track in register
	CMPA	#$12		;is it track 12 or less
	BCC	SKTRK5		;no, skip next
	LDAA	P1DATA		;disable write precompensation
	ANDA	#$0FD		;11111101
	STAA	P1DATA
	BRA	SKTRK6		;skip next
SKTRK5:
	LDAA	P1DATA		;enable write precompensation
	ORAA	#$2		;00000010
	STAA	P1DATA
SKTRK6:
	CLRA			;finish up with no error
	RTS
DSKERR:
	LDAA	#$1
	RTS
RDHSEC:
	CMPA	#SECHGH+1	;past end of track?
	BRA	RDSEC0
RDLSEC:
	CMPA	#SECLOW+1
RDSEC0:
	BCC	RDSEC3
RDSEC:
	STAA	CURSEC		;save sector
	LDAA	#$2		;set 4 retries, 2 for each density
	STAA	SECRTY
RDSEC1:
	LDX	#FDCSEC		;get ready to set FDC sector register
	LDAA	CURSEC		;with sector
	STAA	$0,X		;do it
	LDX	#RDSEC4		;set up interrupt handler
	STX	INTHAN
	LDX	#FDCCMD		;get ready to set FDC command register
	LDAA	#$84		;read sector command with no side compare *****
				;and 30ms delay
;	LDAA	#$8C		;read sector command *********
;	ORAA	SIDE		;set side select *********
	STAA	$0,X		;do it
	LDX	DMADDR		point to memory to save data
RDSEC2:
	LDAB	P1DATA		;check if disk in place and FDC DRQ
	BITB	#$5		;00000101
	BEQ	RDSEC2		;loop until check positive
	LDAA	$0,X		;get data
	INX			;next memory address
	BITB	#$1		;disk in place?
	BEQ	RDSEC2		;yes go for more data
	JSR	FORINT		;force interrupt
	LDAA	#$4		;missing media error
	BRA	RDSEC7		;exit
RDSEC3:
	LDAA	#$1		;missing block error
	BRA	RDSEC7		;exit
RDSEC4:
	LDAB	STFDC		;get floppy disk status
	LDAA	#$3		;assume error 3, CRC
	BITB	#$0C		;test status
	BEQ	RDSEC6		;no, its not
RDSEC5:
	DEC	SECRTY		;decrement retries
	BEQ	RDSEC7		;exit if all gone
	BRA	RDSEC1		;do a retry
RDSEC6:
	LDAA	#$2		;assume error 2
	BITB	#$10		;test for sector not found
	BNE	RDSEC5		;if not, no error so exit
	CLRA			;no error 
RDSEC7:
	RTS			;exit
WRHSEC:
	CMPA	#SECHGH+1	;past end of track
	BRA	WRTSC0
WRLSEC:
	CMPA	#SECLOW+1	;past end of track
WRTSC0:
	BCC	WRTSC3		;exit missing block
WRTSEC:
	STAA	CURSEC		;save in current sector
	LDAA	#$2		;set retries
	STAA	SECRTY
WRTSC1:
	LDAA	CURSEC		;get current sector
	LDX	#FDCSEC		;prepare to write to FDC sector register
	STAA	$0,X		;do it
	LDX	#WRTSC4		;set up interrupt handler
	STX	INTHAN
	LDAA	#$0A4		;FDC write command ******
;	LDAA	#$0AC		;FDC write command *********
;	ORAA	SIDE		;set side select *********
	LDX	#FDCCMD		;prepare to write to FDC command register
	STAA	$0,X		;do it
	LDX	DMADDR
WRTSC2:
	LDAB	P1DATA		;check if disk in place and FDC DRQ
	BITB	#$5		;00000101
	BEQ	WRTSC2		;loop until check positive
	LDAA	$0,X		;get data
	INX			;next memory address
	BITB	#$1		;disk still in place
	BEQ	WRTSC2		;yes go for more data
	JSR	FORINT		;force interrupt
	LDAA	#$4		;missing media error
	BRA	WRTSC7		;exit
WRTSC3:
	LDAA	#$1		;missing block error
	BRA	WRTSC7		;exit
WRTSC4:
	LDAB	STFDC		;get floppy disk status
	LDAA	#$2		;assume missing block error
	BITB	#$14		;test status
	BEQ	WRTSC6		;not missing block
WRTSC5:
	DEC	SECRTY		;decrement retry count
	BEQ	WRTSC7		;do another
	BRA	WRTSC1		;else exit
WRTSC6:
	LDAA	#$3		;assume write protect error
	BITB	#$40		;test status
	BNE	WRTSC7		;got write protect error
	CLRA			;everything OK
WRTSC7:
	RTS			;exit

FLPDEN:
	LDAA	P1DATA		;ready to test if in high density mode
	ANDA	#$8		;test it
	BNE	LOWDEN		;in high so set low
HGHDEN:
	LDAA	P1DATA		;get port 1 data
	ORAA	#$8		;turn on high density bit
	BRA	SETDEN
LOWDEN:
	LDAA	P1DATA		;get port 1 data
	ANDA	#$0F7		;turn off high density bit
SETDEN:
	STAA	P1DATA		;set it
	RTS
SELDRV:
	PSHA			;save A & IX
	PSHX
	LDAA	P1DATA		;test if drive is selected
	BITA	#$20		;00100000
	BNE	SELDR3		;yes, finish up
	ORAA	#$70		;turn motor on, select drive and side 0 01110000
	STAA	P1DATA
	LDAA	#$2		;counter for outer wait loop
SELDR1:
	LDX	#$9C40		;counter for inner wait loop
SELDR2:
	DEX
	BNE	SELDR2		;do inner loop
	DECA
	BNE	SELDR1		;do outer loop
SELDR3:
	PULX			;restore IX and A
	PULA
	RTS
;
RCOUNT:
	LDAA	TCSR		;set output compare to counter + 3E80H
	LDD	COUNTER
	ADDD	#$3E80
	STD	OUTCMP
	LDAA	#$0FA		;put 0FAH in MOTON
	STAA	MOTON
	RTS
;
;	LDAA	#$3		;unused code
;	STAA	PSTAT
;
FORINT:
	LDX	#FDCCMD		;get ready to write to FDC command register
	LDAA	#$0D0		;force interrupt cmd - terminate with
				;no interrupt
	STAA	$0,X		;do it
	LDAA	#$1		;set drive not used
	STAA	DRVUSE
	RTS
;
LSECTRN:
	PSHX			;save IX & B
	PSHB
	LDX	#SKEW9		;point to 9 sector skew table
	BRA	SECTRN
HSECTRN:
	PSHX			;save IX & B
	PSHB
	LDX	#SKEW18		;point to 18 sector skew table
SECTRN:
	TAB			;transfer A to B
	DECB			;dec B
SCTRN1:
	ABX			;add offset
	LDAA	$0,X		;get physical sector
	PULB			;restore IX & B
	PULX
	RTS
SKEW9:
;
;	Double density:
;	To enable Orphanware sector translation (3:1 Skew), comment
;	out the second line; to enable E&T sector translation (4:1
;	skew), comment out the first line below)
;	DB	1,4,7,2,5,8,3,6,9	;Orphanware Sector Translation
	DB	1,5,9,4,8,3,7,2,6	:E&T Sector Translation
;
;	High density: always 4:1 (E&T)
SKEW18:		
	DB	1,5,9,13,17,3,7,11,15,2,6,10,14,18,4,8,12,16
;
FDCINT:
	LDX	#FDCSTAT	;read FDC status register
	LDAA	$0,X
	TSX			;transfer stack pointer to X
	LDAB	#$5		;increase by 5
	ABX
	LDD	INTHAN		;get interrupt handler in DA
	STAA	$0,X		;put in stack
	INX
	STAB	$0,X
	LDX	#FDCSTAT	;prepare to read FDC status register
FDCIN2:
	BRN	FDCIN2		;delay
	LDAA	$0,X		;read status
	STAA	STFDC
	RTI
	RTI
LFORM:
	JSR	LOWDEN
	BRA	FORM1
FORMAT:
	JSR	HGHDEN		;set high density mode
FORM1:
	CLR	SIDE		;clear side 2 flag
	LDAA	P1DATA		;is disk in place?
	BITA	#$1
	BEQ	FMT0		;yes, go on formatting
	LDAA	#$10		;turn motor and drive off, select side 0
	STAA	P1DATA
	RTS
FMT0:
	ORAA	#$10
	STAA	P1DATA
FMT1:
	JSR	HOMDSK		;home disk ****** useless should comment out
	LDAA	#MAXTRK-1	;set track to format
	STAA	FMTTRK
FMT2:
	LDX	#FMT4		;set up interrupt handler
	STX	INTHAN
	LDX	#FDCDAT		;prepare to write to FDC data register
	LDAA	FMTTRK		;get track
	STAA	$0,X		;put in data register
	LDX	#FDCCMD		;prepare to write to FDC command register
	LDAA	#$11		;seek command, no verify, 6ms step
	STAA	$0,X		;issue command
FMT3:
	BRA	FMT3		;wait for seek to end
FMT4:
	LDAA	#$0A		;set format retries to 10
	STAA	FMTRTRY
FMT5:
	LDAA	P1DATA		;turn motor on, and select drive 1, leave side
;	ANDA	#$70		;01110000
	ORAA	#$60		;01100000
	STAA	P1DATA
	LDAA	#$1		;set format sector to 1
	STAA	FMTSEC
	LDX	#FMT37		;set up pointer to interrupt handler
	STX	INTHAN
	LDAA	FMTTRK		;get current track
	CMPA	#$12		;is it less than 12
	BCC	FMT6		;no, jump
	LDAA	P1DATA		;disable write precompensation
	ANDA	#$0FD		;11111101
	BRA	FMT7
FMT6:
	LDAA	P1DATA		;enable write precompensation
	ORAA	#$2		;00000010
FMT7:
	STAA	P1DATA
	LDAA	#$0F0		;FDC write track command in A
	LDX	#FDCCMD		;prepare to write to FDC command register
	STAA	$0,X		;do it
	LDX	#FDCDAT		;prepare to write to FDC data register
	LDAB	#$64		;write 64H/100D bytes of data
FMT8:
	LDAA	#$4		;prepare to test DRQ
FMT9:
	BITA	P1DATA		;test it
	BEQ	FMT9		;loop til set
	LDAA	#$4E		;write 4EH
	STAA	$0,X
	DECB			;decrement count
	BNE	FMT8		;loop till count gone
FMT10:
	LDAB	#$0C		;now writing 0CH/12D bytes
FMT11:
	LDAA	#$4		;prepare to test DRQ
FMT12:
	BITA	P1DATA		;test it
	BEQ	FMT12		;loop till set
	CLRA			;write 0
	STAA	$0,X		;do it
	DECB			;decrement count
	BNE	FMT11		;loop till exhausted
	LDAB	#$3		;now write 3 bytes
FMT13:
	LDAA	#$4		;prepare to test DRQ
FMT14:
	BITA	P1DATA		;test it
	BEQ	FMT14		;loop till set
	LDAA	#$0F5		;write 0F5H (3 bytes of A1)
	STAA	$0,X		;do it
	DECB			;decrement count
	BNE	FMT13		;loop till exhausted
	LDAA	#$4		;prepare to test DRQ
FMT15:
	BITA	P1DATA		;test it
	BEQ	FMT15		;loop till set
	LDAA	#$0FE		;write 0FEH (index mark)
	STAA	$0,X		;do it
	LDAA	#$4		;prepare to test DRQ
FMT16:
	BITA	P1DATA		;test it
	BEQ	FMT16		;loop till set
	LDAA	FMTTRK		;get track number
	STAA	$0,X		;wwrite to FDC
	LDAA	#$4		;prepare to test DRQ
FMT17:
	BITA	P1DATA		;test it
	BEQ	FMT17		;loop till set
	LDAA	SIDE		;get side
;	LSRA			;convert to 0&1 instead of 0&2 ******
	STAA	$0,X		;write it
	LDAA	#$4		;prepare to test DRQ
FMT18:
	BITA	P1DATA		;test it
	BEQ	FMT18		;loop till set
	LDAA	FMTSEC		;get sector number
	STAA	$0,X		;write it
	INCA			;increment sector number
	STAA	FMTSEC		;save it
	LDAA	#$4		;prepare to test DRQ
FMT19:
	BITA	P1DATA		;test it
	BEQ	FMT19		;wait till set
	LDAA	#$2		;write sector length byte (2 = 512 bytes)
	STAA	$0,X		;write it
	LDAA	#$4		;prepare to test DRQ
FMT20:
	BITA	P1DATA		;test it
	BEQ	FMT20		;loop till set
	LDAA	#$0F7		;write 0F7H (writes CRC)
	STAA	$0,X		;write it
	LDAB	#$16		;load count with 16H/22D
FMT21:
	LDAA	#$4		;prepare to test DRQ
FMT22:
	BITA	P1DATA		;test it
	BEQ	FMT22		;loop till set
	LDAA	#$4E		;write 4EH
	STAA	$0,X		;write it
	DECB			;decrement count
	BNE	FMT21		;loop till exhausted
	LDAB	#$0C		;load count with 0CH/12D
FMT23:
	LDAA	#$4		;get ready to test DRQ
FMT24:
	BITA	P1DATA		;test it
	BEQ	FMT24		;loop till done
	CLRA			;write 0
	STAA	$0,X		;write it
	DECB			;decrement count
	BNE	FMT23		;loop till exhausted
	LDAB	#$3		;count = 3
FMT25:
	LDAA	#$4		;prepare to test DRQ
FMT26:
	BITA	P1DATA		;test it
	BEQ	FMT26		;loop till set
	LDAA	#$0F5		;write 0F5H (3 bytes of A1)
	STAA	$0,X		;write it
	DECB			;decrement count
	BNE	FMT25		;loop till exhausted
	LDAA	#$4		;prepare to test DRQ
FMT27:
	BITA	P1DATA		;test it
	BEQ	FMT27		;loop till set
	LDAA	#$0FB		;write 0FBH (address mark)
	STAA	$0,X		;write it
	CLRB			;clear B (count = 256)
FMT28:
	LDAA	#$4		;prepare to test DRQ
FMT29:
	BITA	P1DATA		;test it
	BEQ	FMT29		;loop till set
	LDAA	#$0E5		;write 0E5H
	STAA	$0,X		;write it
	DECB			;decrement count
	BNE	FMT28		;loop till exhausted
FMT30:
	LDAA	#$4		;prepare to test DRQ
FMT31:
	BITA	P1DATA		;test it
	BEQ	FMT31		;loop till set
	LDAA	#$0E5		;writing 0E5H
	STAA	$0,X		;write it
	DECB			;decrement count
	BNE	FMT30		;loop till exhausted
	LDAA	#$4		;prepare to test DRQ
FMT32:
	BITA	P1DATA		;test it
	BEQ	FMT32		;loop till set
	LDAA	#$0F7		;writing 0F7H (CRC)
	STAA	$0,X		;write it
	LDAB	#$64		;count = 64H/100D
FMT33:
	LDAA	#$4		;prepare to test DRQ
FMT34:
	BITA	P1DATA		;test it
	BEQ	FMT34		;loop till set
	LDAA	#$4E		;writing 4EH
	STAA	$0,X		;write it
	DECB			;decrement count
	BNE	FMT33		;loop till exhausted
	LDAA	P1DATA
	ANDA	#$8
	BEQ	FMT34A
	LDAA	FMTSEC
	CMPA	#SECHGH+1
	BEQ	FMT35
	JMP	FMT10		;no, go back and write another sector
FMT34A:
	LDAA	FMTSEC
	CMPA	#SECLOW+1
	BEQ	FMT35
	JMP	FMT10		;no, go back and write another sector
FMT35:
	LDAB	#$4E		;get ready to fill track with 4EH
FMT36:
	LDAA	P1DATA		;test DRQ
	BITA	#$4		;is it set
	BEQ	FMT36		;no, loop till set
	STAB	$0,X		;write byte
	BRA	FMT36		;loop till FDC interrupts out
FMT37:				;format continues here once one track is formatted
	LDX	#FDCSTAT	;read FDC status register
	LDAB	$0,X
	BITB	#$1		;test busy
	BNE	FMT37		;wait till not busy
	LDAA	STFDC		;get status after command completed
	BITA	#$4		;test for lost data
	BEQ	FMT38		;jump if none
FMT37A:
	DEC	FMTRTRY		;decrement retries
	BEQ	FMT37C		;go on if exhausted
	LDAA	FMTRTRY
	CMPA	#$5
	BNE	FMT37B
	JSR	FLPDEN
FMT37B:
	JMP	FMT5		;re-format track
FMT37C:
	RTS
FMT38:
	LDAA	FMTTRK
	CMPA	#MAXTRK-1
	BNE	FMT38A
	LDAA	SIDE
	BNE	FMT38A
	LDD	#RDMA0		;DMA read to 1st half of memory
	STD	DMADDR
	LDAA	#$3
	JSR	RDSEC
	TSTA
	BNE	FMT37A
FMT38A:
;	LDDA	BLKRD		;read first byte of data block
;	CMPA	#$1		;is it 1
;	BEQ	FMT39		;if it is, do not format side 1
	LDAA	SIDE		;get the side
	BNE	FMT39		;jump if we just did side 1
	INC	SIDE		;increment side *******
;	LDAA	#$2		;********
;	STAA	SIDE		;********
;comment out next 3 lines if using 2797 side select line
	LDAA	P1DATA		;select side 1
	ANDA	#$0EF		;11101111
	STAA	P1DATA
	BRA	FMT40		;skip next
FMT39:
	CLR	SIDE		;select side 0
;comment out next 3 lines if using 2797 side select line
	LDAA	P1DATA
	ORAA	#$10		;00010000
	STAA	P1DATA
	DEC	FMTTRK		;decrement track to format
FMT40:
	LDAA	FMTTRK		;check if formatted all tracks
	CMPA	#$0FF
	BEQ	FMT41		;yes finish up
	JMP	FMT2		;no, go back and format new track
FMT41:
	JMP	HOMDSK		;home the disk (it already is)
;
	ORG	0F800H
;
	TBA
;
SCIINT:
	TST	DATREQ		;is there an active data request
	BNE	SCINT3		;if none, finish up, ignoring Net
	JSR	RDSCI		;read byte from SCI
	BCS	SCINT4		;jump if good read (and good net address)
	BVC	SCINT3		;if address bad, finish up, ignoring Net
				;must be bad read, so NACK it
	LDAA	#$2		;enable Tx interrupt
	STAA	SCICSR
SCINT1:
	LDX	#$0E		;set wait count
	LDAA	#$8		;get ready to test bit 3
SCINT2:
	BITA	P2DATA		;is bit 3 of port 2 data set by SCI
	BEQ	SCINT1		;no, loop until it's set
	DEX			;make sure it stays set long enough
	BNE	SCINT2		;by looping until IX = 0
	LDAA	#$1B		;enable Rx, RxI, Wakeup
	STAA	SCICSR
	TST	CMDSTG		;are we in the middle of a command
	BEQ	SCINT3		;no, just reset SCI
	CLRA			;clear command stage flag
	STAA	CMDSTG
	JMP	NACK		;send NACK
SCINT3:
	LDAB	#$1B		;enable Rx, RxI, Wakeup
	STAB	SCICSR
	CLRA			;clear command stage flag
	STAA	CMDSTG
	JMP	SCIEND		;reset SCI
SCINT4:
	LDAB	CMDSTG		;get the command stage flag in B
	ASLB			;multiply by 2
	LDX	#TBL1		;point to command jump table
	ABX			;add offset in B
	LDX	$0,X		;get address from table
JMPIX:
	JMP	$0,X		;jump to address
TBL1:
	DW	STAGE0
	DW	STAGE1
	DW	STAGE2
	DW	STAGE3
	DW	STAGE4
	DW	STAGE5
STAGE0:
	ANDA	#$0F0		;mask off lower nibble
	CMPA	#$0		;is it NetReset
	BNE	NOTRST		;no, check other commands
;	SEC			;set carry
;	JSR	SETREQ
	LDAA	#$0FF		;put FF in DATREQ
	STAA	DATREQ
	JMP	SCIEND		;reset SCI
NOTRST:
	CMPA	#$10		;is it status request?
	BEQ	STATUS		;yes, jump
	CMPA	#$30		;is it clear
	BNE	NOTCLR		;no, jump
	JMP	CLEAR
NOTCLR:
	CMPA	#$40		;is it Rx
	BNE	NOTRX		;no, jump
	LDX	#$5		;counter to test 5 bytes
RX1:
	LDAA	$7F,X		;compare location 7F+X
	CMPA	$84,X		;to location 84+X
	BNE	RX2		;jump if different
	DEX			;check counter
	BNE	RX1		;loop if more bytes to check
	BRA	ACK		;all the same to send ACK
RX2:
	LDAA	#$0B
;	CLC
;	JSR	SETREQ
	STAA	RDWRT		;put's 0BH in RDWRT to force a read
	LDAA	#$0AA		;put AA in DATREQ
	STAA	DATREQ
	LDAA	#$0B		;disable receive interrupt
	STAA	SCICSR
	JMP	SCIEND
NOTRX:
	CMPA	#$60		;is it send
	BNE	NOTSND		;no, jump
	LDAA	#$1		;now stage 0
	STAA	CMDSTG		;so set it
	JMP	SCIEND		;reset SCi
NOTSND:
	CMPA	#$0D0		;is it RDY
	BEQ	ACK		;yes, send ACK
	JMP	SCIEND		;else reset SCI (ignore command)
NACK:
	LDAA	#$0C0		;NACK in upper nibble of A
	ORAA	DEVNUM		;node ID in lower nibble of A
	JSR	TXBYTE		;send it
	BCS	NACK1		;if bad send
	JSR	RXBYTE		;get response
	BCS	NACK1		;if bad receive
	JMP	SCIEND		;reset SCI
NACK1:
	JMP	RETI		;return from interrupt
ACK:
	LDAA	#$90		;ACK in upper nibble of A
	ORAA	DEVNUM		;node ID in lower nibble
	JSR	TXBYTE		;send it
	BCS	ACK1		;if bad send
	JSR	RXBYTE		;get response
	BCS	ACK1		;if bad receive
	JMP	SCIEND		;reset SCI
ACK1:
	JMP	RETI		;return from interrupt
STATUS:
	LDD	TBL2		;load double accumulator with 8000H
				;(status + MSB of msg len)
	ORAA	DEVNUM		;put device number in lower nibble of A (=80)
	STD	MSTAT		;save in buffer for status message
	LDD	TBL3		;load double accumulator with 401H
	STD	MSTAT+2		;put in 91 and 92
	JSR	GETSTAT		;put double stat in 93
	LDX	#MSTAT		;point to string to send
	LDD	#$5		;load double accumulator with string length
	STD	STRLEN		;save string length
	LDAA	#$80		;initialize checksum
	ORAA	DEVNUM
	STAA	CHKSUM
	JSR	TXSTR		;send response
	BCS	STAT1		;if error
;	LDAA	#$1
;	STAA	L0096		;put 1 if ???? flag - not used anywhere else
	JMP	SCIEND		;reset SCI
STAT1:
	JMP	RETI		;jump to RTI
CLEAR:
	TST	CURMSG+4	;was the last command for primary device
	BEQ	CLR1		;yes, skip next
	LDAA	SSTAT		;so load secondary device status
	BRA	CLR2		;skip next
CLR1:
	LDAA	PSTAT		;get primary device status
CLR2:
	CMPA	#$3		;test status
	BCC	CLR3		;if 3 or greater, jump
	LDX	#BLKRD		;get ready to read external memory
	LDD	#$0400		;400H to send
	STD	STRLEN		;so set message length
	BRA	CLR4		;skip next
CLR3:
	JSR	GETSTAT		;put combined status message in CSTAT
	LDX	#CSTAT		;point to CSTAT
	LDD	#$1		;message length = 1
	STD	STRLEN
CLR4:
	JSR	SNDMSG		;send message (Block or error)
	BCS	CLR8		;if error
	TST	CURMSG+4	;was last for primary device
	BEQ	CLR5		;yes, skip next
	LDAA	SSTAT		;get secondary status
	BRA	CLR6		;skip next
CLR5:
	LDAA	PSTAT		;get primary status
CLR6:
	CMPA	#$1		;test status
	BNE	CLR7		;if not 1, jump
	LDAA	#$0FF		;set external memory contents bad
	STAA	LSTMSG+4
CLR7:
	JMP	SCIEND		;exit
CLR8:
	JMP	RETI		;do simple RTI
STAGE1:
				;A = MSB of message length
	STAA	STRLEN		;save MSB of message length
	LDAA	#$2		;activate stage 2
	STAA	CMDSTG
	JMP	SCIEND		;reset SCI
STAGE2:
				;A = LSB of message length
	STAA	STRLEN+1	;save LSB of message length
	CMPA	#$5		;is it 5?
	BNE	STAG21		;no, it must be 400H
	LDAA	STRLEN		;get MSB of message length
	BEQ	STAG22		;if it's 0, ie 0005, jump
STAG21:
	LDAA	#$3		;activate stage 3
	STAA	CMDSTG
	LDD	#BLKWRT		;block to go at 400H
	STD	BLKLOC
	JMP	SCIEND		;reset SCI
STAG22:
	LDAA	#$4		;activate stage 4
	STAA	CMDSTG
	LDD	#$80		;block to go at 80H
	STD	BLKLOC
	CLR	CHKSUM		;clear the checksum
	JMP	SCIEND		;reset SCI
STAGE3:
				;A = first byte of message
	LDAB	#$4		;activate stage 4
	STAB	CMDSTG
	CLR	CHKSUM		;clear checksum
STAGE4:
				;A = message byte
	LDX	BLKLOC		;get memory location to save message
	STAA	$0,X		;save there
	INX			;increment pointer
	STX	BLKLOC		;save it
	EORA	CHKSUM		;calculate checksum
	STAA	CHKSUM		;save it
	LDD	STRLEN		;get message length
	SUBD	#$1		;decrement it
	STD	STRLEN		;save it
	BNE	SCIEND		;reset SCI if not done
	LDAA	#$5		;else activate stage 5
	STAA	CMDSTG
	BRA	SCIEND		;and reset SCI
STAGE5:
				;A = message checksum
	LDAB	#$0		;reset commmand stage to 0
	STAB	CMDSTG
	CMPA	CHKSUM		;check against calculated checksum
	BEQ	STAG51		;if they're the same jump
	LDAA	#$2		;else set primary status to 2
	STAA	PSTAT
	JMP	NACK		;and send NACK
STAG51:
	LDX	BLKLOC		;check if loaded at 80H or 400H
	CPX	#$0100
	BCS	STAG52		;carry set if 80H, so just send ACK
	LDAA	#$0C		;set data write
	STAA	RDWRT
	LDAA	#$0AA		;data request flag
	STAA	DATREQ
STAG52:
	JMP	ACK		;send ACK
SNDMSG:
	LDAA	#$0B0		;Minor node send
	ORAA	DEVNUM		;or in Node ID
	JSR	TXBYTE		;send it
	BCS	TXSTR1		;if bad send
	LDAA	STRLEN		;get message length MSB
	JSR	TXBYTE		;send it
	BCS	TXSTR1		;if bad send
	LDAA	STRLEN+1	;get message length LSB
	JSR	TXBYTE		;send it
	BCS	TXSTR1		;if bad send
	CLR	CHKSUM		;clear checksum and fall through to send message
TXSTR:
	LDAA	$0,X		;get byte pointed to by IX
	JSR	TXBYTE		;send it
	BCS	TXSTR1		;jump if error
	EORA	CHKSUM		;generate checksum
	STAA	CHKSUM		;save it
	INX			;increment pointer
	LDD	STRLEN		;load DA with string length
	SUBD	#$1		;decrement it
	STD	STRLEN		;save string length
	BNE	TXSTR		;send more if leength > 0
	LDAA	CHKSUM		;get checksum
	JSR	TXBYTE		;send it
	BCS	TXSTR1		;if error
	JSR	RXBYTE		;get response
TXSTR1:
	RTS
SCIEND:
	TST	DATREQ		;test SCI status flag
	BEQ	RETI		;if it's 0 exit, SCI routine
	LDAA	#$0A		;enable Rx & Tx, but disable interrupts
	STAA	SCICSR
	LDAA	SCICSR		;read status to reset
	LDAA	SCIRXD		;read receive to reset
	JSR	RXBYTE		;read byte from Net
RETI:
	RTI			;return from SCI interrupt
GETSTAT:
	LDAA	SSTAT		;get contents of 95 in A
	ASLA			;put in upper nibble
	ASLA
	ASLA
	ASLA
	ORAA	PSTAT		;put 94 in lower nibble
	STAA	CSTAT		;save in 93
	RTS
TBL2:
	DW	$8000
TBL3:
	DW	$401
	DB	$0
RDSCI:
	SEC			;set carry flag
	LDAB	SCICSR		;get SCI status in B
	LDAA	SCIRXD		;read SCI data
	ANDB	#$40		;check for read errors, carry not affected
	BEQ	RDSCI1		;branch if no error
	CLC			;clear the carry
	SEV			;set overflow
	RTS
RDSCI1:
	LDAB	CMDSTG		;check if in middle of a command
	BNE	RDSCI3		;branch if so
	TAB			;transfer Node ID to B
	ANDA	#$0F		;look at lower nibble of ID
	CMPA	DEVNUM		;is it us
	BNE	RDSCI2		;jump if not
	TBA			;put byte back in A
	SEC			;set the carry
	BRA	RDSCI3		;clear next
RDSCI2:
	CLC			;clear carry
RDSCI3:
	CLV			;clear overflow
	RTS
TXBYTE:
	PSHX			;save IX
	LDX	#$16		;store count for timeout
TXBYT1:
	DEX			;decrement count
	BEQ	TXBYT2		;timeout if count exhausted
	LDAB	SCICSR		;get SCI status
	ANDB	#$20		;is Tx register full
	BEQ	TXBYT1		;wait if it is
	STAA	SCITXD		;put byte in Tx register (send it)
	CLC			;clear the carry
	BRA	TXBYT3		;exit
TXBYT2:
	JSR	SCIRES		;reset SCI
	SEC			;set the carry
TXBYT3:
	PULX			;restore IX
	RTS
RXBYTE:
	PSHX			;save IX
	LDX	#$22		;count for timeout
RXBYT1:
	DEX			;decrement count
	BEQ	RXBYT3		;timeout if count exhausted
	LDAB	SCICSR		;get SCI status
	ANDB	#$20		;check if last byte transmitted yet
	BEQ	RXBYT1		;wait until it is
	LDAB	SCIRXD		;read Rx data
RXBYT2:
	DEX			;decrement counter
	BEQ	RXBYT3		;if timed out
	LDAB	SCICSR		;read SCI status
	BPL	RXBYT2		;loop if bit 7 is not set
	LDAB	SCIRXD		;read byte
	PULX			;restore IX
	RTS
RXBYT3:
	BSR	SCIRES		;reset SCI
	PULX			;restore IX
	RTS
SCIRES:
	LDAB	SCICSR		;read SCI status
	LDAB	SCIRXD		;clear any received data
	LDAB	#$1B		;enable Rx, Tx, Wakeup
	STAB	SCICSR
	LDAB	#$0		;reset command stage to 0
	STAB	CMDSTG
	RTS
;
	ORG	0FFF0H
;
;RETI:
;	RTI			;return from interrupt
	DW	SCIINT		;IRQ2/SCI (RDRF,ORFE,TDRE)
	DW	RETI		;IRQ2/Timer overflow
	DW	RETI		;IRQ2/Timer output compare
	DW	RETI		;IRQ2/Timer input capture
	DW	RETI		;IRQ1 interrupt (IRQ1 - IS3)
	DW	RETI		;software interrupt (SWI)
	DW	FDCINT		;Non-maskable Interrupt
	DW	RESET		;reset
	END
